$(document).ready(function() {
	
	$('.summernote').summernote({height: 150});
					
	var clipboard = new ClipboardJS('.btn-copy-link');
	
	clipboard.on('success', function(e) {
	    
	    $(e.trigger).html("Copied!").addClass("disabled");
	    
	    setTimeout(function() {
		    $(e.trigger).html("<i class='fas fa-copy'></i> Copy Quiz Link").removeClass("disabled");
	    }, 2000);
	
	    e.clearSelection();
	});
	
	$(".menu-item").click(function(e) {
		
		e.preventDefault();
		
		window.location = $(this).attr("data-url");
		
	});
	
	$('.menu-select-mob').change(function() {
	    var menu_page = $(this).val();
	    
	    if(menu_page != "0") {
		    window.location = menu_page;
	    }
	});
					
	$(".btn-delete").click(function(e) {

		e.preventDefault();
		
		var page_id = $(this).attr("data-id");
		
		var r = confirm("Are you sure that you want to completely delete this page?");
		if (r == true) {
									
			$.ajax({
				url: "ajax/delete-page.php",
				type: 'POST',
		        data: {
			        page_id: page_id
		        },
		        dataType: "json",
		        success: function (data) {
			        
			        if(data.status == 0) {
				        showError(data.error);
			        } else {
				        
				        $(".quiz-line[data-id=" + page_id + "]").remove();
				        
			        }
			        
			    }
			});
			
		}
		
	});
	
	function showError(msg) {
		$.toast({
			text: msg,
			bgColor : '#e74c3c',
			textColor : '#fff', 
			position : 'top-right'
		});
	}
	
});
	
